<?php
/*
*   Copyright 2008 Boris Tomić
*
*   Licensed under the Apache License, Version 2.0 (the "License");
*   you may not use this file except in compliance with the License.
*   You may obtain a copy of the License at
*
*       http://www.apache.org/licenses/LICENSE-2.0
*
*   Unless required by applicable law or agreed to in writing, software
*   distributed under the License is distributed on an "AS IS" BASIS,
*   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*   See the License for the specific language governing permissions and
*   limitations under the License.
*/ 

require_once 'Zend/Validate/Abstract.php';
require_once '../Core/lib/ZFext/Validate/Array.php';

class Equal extends Zend_Validate_Abstract {
	const MSG_NOTEQUAL = 'notequal';
	protected $_fieldName;
	protected $_fields;
	protected $_otherValue;
	public function __construct(Zend_Validate_Array & $fields, $fieldName){
		$this->_fields = & $fields;
		$this->_fieldName = $fieldName;
		$this->_otherValue = null;
	}
	protected  $_messageTemplates = array(
        self::MSG_NOTEQUAL => "Value %value% not equal to value %otherValue%"
    );
    public function isValid($value){
    	$this->_setValue($value);
    	$this->_otherValue = $this->_fields->getValues($this->_fieldName);
    	if($value == $this->_otherValue)
    		return true;
    	$this->_error(self::MSG_NOTEQUAL);
    	return false;
    }
}