<?php
/*
*   Copyright 2008 Boris Tomić
*
*   Licensed under the Apache License, Version 2.0 (the "License");
*   you may not use this file except in compliance with the License.
*   You may obtain a copy of the License at
*
*       http://www.apache.org/licenses/LICENSE-2.0
*
*   Unless required by applicable law or agreed to in writing, software
*   distributed under the License is distributed on an "AS IS" BASIS,
*   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*   See the License for the specific language governing permissions and
*   limitations under the License.
*/ 

require_once 'Zend/Validate/Abstract.php';

/**
 * this is special purpose class used in Zend_Validate_Array
 * It helps to solve problems with required and empty fields.
 * If field does not have this validator set and it has empty value
 * it will still be valid
 */
class Zend_Validate_Array_Required extends Zend_Validate_Abstract {
	const MSG_REQUIRED = 'msgrequired';
	protected  $_messageTemplates = array(
        self::MSG_REQUIRED => "Value required but got empty value."
    );
    public function isValid($value){
    	if($value == "" || $value == null){
    		$this->_error(self::MSG_REQUIRED);
    		return false;
    	}
    	return true;
    }
}