<?php
/*
*   Copyright 2008 Boris Tomic
*
*   Licensed under the Apache License, Version 2.0 (the "License");
*   you may not use this file except in compliance with the License.
*   You may obtain a copy of the License at
*
*       http://www.apache.org/licenses/LICENSE-2.0
*
*   Unless required by applicable law or agreed to in writing, software
*   distributed under the License is distributed on an "AS IS" BASIS,
*   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*   See the License for the specific language governing permissions and
*   limitations under the License.
*/

class Zend_Validate_Array_Field {
	private $name;
	private $parent;
	public function __construct($name, Zend_Validate_Array &$parent){
		$this->parent = &$parent;
		$this->name = $name;
	}
	public function addFilter(Zend_Filter_Interface $filter){
		$this->parent->addFilter($this->name, $filter);
		return $this;
	}
	public function addValidator(Zend_Validate_Interface $validate, $error = null, $options = null){
		$this->parent->addValidator($this->name, $validate, $error, $options);
		return $this;
	}
}